//
//  AppDelegate.swift
//  CCS China Portal
//
//  Created by CCS China Portal on 10/10/15.
//  Copyright © 2015 CCS China Portal. All rights reserved.
//

import UIKit

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {

    var window: UIWindow?


    func application(application: UIApplication, didFinishLaunchingWithOptions launchOptions: [NSObject: AnyObject]?) -> Bool {
        // Override point for customization after application launch.
        if(SBKBeaconManager.sharedInstance() != nil)
        {
            
            SBKBeaconManager.sharedInstance().requestAlwaysAuthorization();
        }
        
      
        return true
    }

    func applicationWillResignActive(application: UIApplication) {
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(application: UIApplication) {
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }

    func applicationWillEnterForeground(application: UIApplication) {
        // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
    }

    func applicationDidBecomeActive(application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
        application.applicationIconBadgeNumber = -2;
    }

    func applicationWillTerminate(application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    
    }

    func application(application: UIApplication, didRegisterUserNotificationSettings notificationSettings: UIUserNotificationSettings) {
        application.registerForRemoteNotifications();
    }
    func application(application: UIApplication, handleActionWithIdentifier identifier: String?, forRemoteNotification userInfo: [NSObject : AnyObject], completionHandler: () -> Void) {
        if(identifier == "declineAction")
        {
            print("My token is declined");
        }
        else if(identifier == "answerAction")
        {
            print("My token is here");
            
            
        }
    }
    
    func application(application: UIApplication, didReceiveRemoteNotification userInfo: [NSObject : AnyObject]) {
      
            print("\(userInfo)");
        
        if let aps = userInfo["aps"] as? NSDictionary {
            if let alert = aps["alert"] as? NSDictionary {
                if let message = alert["message"] as? NSString {
                    //Do stuff
                    print(message)
                    print(aps["badge"]?.integerValue);
                     application.applicationIconBadgeNumber =  (aps["badge"]?.integerValue)!;
                }
            } else if let alert = aps["alert"] as? NSString {
                //Do stuff
                print("alert \(alert)")
            }
           

        }
        
        
        
        
        
    }
    
    func application(application: UIApplication, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: NSData) {
        
        let tokenChars = UnsafePointer<CChar>(deviceToken.bytes)
        var tokenString = ""
        
        for var i = 0; i < deviceToken.length; i++ {
            tokenString += String(format: "%02.2hhx", arguments: [tokenChars[i]])
        }
        
        print("tokenString: \(tokenString)")
        
        
        let viewController:ViewController = self.window?.rootViewController as! ViewController
        
        let userid = viewController.userid;
        print(viewController.userid);
        if(userid != nil)
        {
            objc_sync_enter(self);
            viewController.webView.stringByEvaluatingJavaScriptFromString(NSString(format: "GetTokenFromMobileiOS(\"%@\", \"%@\");", userid!, tokenString) as String);
            objc_sync_exit(self);
        }
        
        
        
    }
    func application(application: UIApplication, didFailToRegisterForRemoteNotificationsWithError error: NSError){
        
        
        print("Failed to get token, error: \(error)");
    }
  
       
    
}

